/*
 * Decompiled with CFR 0.152.
 */
package woolpack.utils;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import woolpack.utils.DelegationMap;
import woolpack.utils.KeyNotEmptyMap;
import woolpack.utils.NotNullMap;
import woolpack.utils.SimilarPropertyNameMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UtilsConstants {
    private UtilsConstants() {
    }

    public static <K, V> Map<K, V> defaultValueMap(Map<K, V> map, final V defaultValue) {
        map.getClass();
        return new DelegationMap<K, V>(map){

            @Override
            public V get(Object key) {
                Object value = super.get(key);
                return value != null ? value : defaultValue;
            }
        };
    }

    public static <K, V> Map<K, V> unoverwritableMap(Map<K, V> map) {
        map.getClass();
        return new DelegationMap<K, V>((Map)map){

            @Override
            public V put(K key, V value) {
                if (super.containsKey(key)) {
                    throw new IllegalArgumentException("duplicate: " + key);
                }
                return super.put(key, value);
            }

            @Override
            public void putAll(Map<? extends K, ? extends V> t) {
                for (Object k : t.keySet()) {
                    if (!super.containsKey(k)) continue;
                    throw new IllegalArgumentException("duplicate: " + k);
                }
                super.putAll(t);
            }
        };
    }

    public static <K, V> Map<K, V> notNullMap(Map<K, V> map) {
        map.getClass();
        return new NotNullMap<K, V>(map);
    }

    public static <V> Map<String, V> keyNotEmptyMap(Map<String, V> map) {
        map.getClass();
        return new KeyNotEmptyMap<V>(map);
    }

    public static <V> Map<String, V> similarKeyMap(Map<String, V> map) {
        map.getClass();
        return new SimilarPropertyNameMap<V>(map);
    }

    public static <T> Iterable<T> unmodifiableIterable(final Iterable<T> iterable) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final Iterator it = iterable.iterator();
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public T next() {
                        return it.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static Iterable toIterable(Object value) {
        if (value instanceof Iterable) {
            return (Iterable)value;
        }
        return UtilsConstants.toListPrivate(value);
    }

    public static Collection toCollection(Object value) {
        if (value instanceof Collection) {
            return (Collection)value;
        }
        return UtilsConstants.toListPrivate(value);
    }

    public static List toList(Object value) {
        if (value instanceof List) {
            return (List)value;
        }
        return UtilsConstants.toListPrivate(value);
    }

    private static List<Object> toListPrivate(final Object value) {
        if (value != null && value.getClass().isArray()) {
            if (value.getClass().getComponentType().isPrimitive()) {
                return new AbstractList<Object>(){

                    @Override
                    public Object get(int index) {
                        return Array.get(value, index);
                    }

                    @Override
                    public int size() {
                        return Array.getLength(value);
                    }

                    @Override
                    public Object set(int index, Object after) {
                        Object before = this.get(index);
                        Array.set(value, index, after);
                        return before;
                    }
                };
            }
            return Arrays.asList((Object[])value);
        }
        return Collections.singletonList(value);
    }

    public static List<String> toMessageList(Throwable t) {
        ArrayList<String> list = new ArrayList<String>();
        while (t != null) {
            String s = t.getLocalizedMessage();
            if (t.getCause() == null) {
                if (s != null) {
                    list.add(s);
                } else {
                    list.add(t.toString());
                }
            } else if (s != null && !t.getCause().toString().equals(s)) {
                list.add(s);
            }
            t = t.getCause();
        }
        return list;
    }
}

