/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.config;

import java.util.Iterator;

/**
 * メッセージの埋め込みを解決後にテンプレートのメッセージを削除するために使用する、
 * チェック文字が値に含まれるキーを削除する{@link ConfigExpression}。
 * メッセージは冗長性があっても静的であるほうが見える化が維持されるため、
 * 動的にメッセージを生成する機構は使用しないことを推奨する。
 * @author nakamura
 *
 */
public class RemoveNotResolved implements ConfigExpression {
	private final char checkChar;
	
	/**
	 * コンストラクタ。
	 * @param checkChar チェック文字。この文字が値に含まれるキーを削除対象とする。
	 */
	public RemoveNotResolved(final char checkChar){
		this.checkChar = checkChar;
	}

	/**
	 * コンストラクタ。
	 * チェック文字を"{"とする。
	 */
	public RemoveNotResolved(){
		this('{');
	}

	/**
	 * @throws NullPointerExcpeption 引数または{@link ConfigContext#getMap()}が null の場合。
	 */
	public void interpret(final ConfigContext context) {
		final Iterator<String> it = context.getMap().keySet().iterator();
		while(it.hasNext()){
			final String key = it.next();
			if(context.getMap().get(key).toString().indexOf(checkChar) >= 0){
				it.remove();
			}
		}
	}
}
