/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.locale;

import java.util.Locale;
import java.util.Map;

import woolpack.config.CacheMap;
import woolpack.config.ConfigExpression;

/**
 * {@link Locale}で{@link Map}をキャッシュし現在のスレッドの{@link Locale}でキャッシュを取り出す{@link CacheMap}。
 * @author nakamura
 *
 */
public class LocaleCacheMap extends CacheMap {
	private final ThreadLocal<Locale> threadLocal;

	/**
	 * コンストラクタ。
	 * @param maxEntries キャッシュに保持する最大{@link Map}数。
	 * @param mapMaker {@link Map}を生成し加工する委譲先の{@link ConfigExpression}。
	 * @param threadLocal 現在のスレッドの{@link Locale}を保持する{@link ThreadLocal}。
	 * @throws NullPointerException 引数のいずれかが null の場合。
	 */
	public LocaleCacheMap(final int maxEntries, final ConfigExpression mapMaker, final ThreadLocal<Locale> threadLocal) {
		super(maxEntries, mapMaker);
		threadLocal.getClass();
		this.threadLocal = threadLocal;
	}

	@Override public Object getCacheKey(){
		final Locale l = threadLocal.get();
		return (l!=null)?l:super.getCacheKey();
	}
}
