/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils;

import java.util.Map;

class KeyNotEmptyMap<V> extends DelegationMap<String,V> {
	KeyNotEmptyMap(final Map<String,V> map){
		super(map);
		checkKeyNotEmpty(map);
	}
	
	private void checkKeyNotEmpty(final Map<? extends String,? extends V> map){
		for(final String k:map.keySet()){
			k.charAt(0);
		}
	}
	
	@Override public V put(final String key, final V value){
		key.charAt(0);
		return super.put(key, value);
	}
	
	@Override public void putAll(Map<? extends String,? extends V> map){
		checkKeyNotEmpty(map);
		super.putAll(map);
	}
}
