/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import java.io.IOException;
import java.util.Collection;

/**
 * 文字列が集合に含まれることを検証してその結果を返す{@link ValidatorExpression}。
 * {@link ValidatorContext}に対して状態を変更する操作を行わない。
 * @author nakamura
 *
 */
abstract public class ValidCollectionValidator extends ValidatorExpressionAdapter {
	private final Collection<String> collection;
	
	/**
	 * コンストラクタ。
	 * @param collection 妥当な文字列の集合。
	 * @throws NullPointerException 引数が null の場合。
	 */
	public ValidCollectionValidator(final Collection<String> collection){
		collection.getClass();
		this.collection = collection;
	}

	@Override public boolean interpret(final ValidatorContext context) {
		return collection.containsAll(getCollection(context));
	}

	@Override public void appendArgumentTo(final Appendable sb) throws IOException {
		ValidatorConstants.appendTo(sb, collection);
	}
	
	/**
	 * {@link #interpret(ValidatorContext)}から呼び出される(called)。
	 * @param context 検証対象。
	 * @return 検証対象から生成したオブジェクトの一覧。
	 */
	abstract public Collection getCollection(ValidatorContext context);
}
