/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import java.io.IOException;
import java.util.Collection;

/**
 * {@link ValidatorExpression}のアダプタクラス。
 * {@link ValidatorExpression#appendTo(Appendable)}ではクラス宣言部を生成し、
 * 引数の生成をサブクラスにさせる Template method デザインパターンを適用している。
 * @author nakamura
 *
 */
abstract public class ValidatorExpressionAdapter implements ValidatorExpression {

	abstract public boolean interpret(final ValidatorContext context);

	public void appendTo(final Appendable sb) throws IOException{
		sb.append("new ");
		sb.append(ValidatorConstants.getLocalClassName(this.getClass()));
		sb.append("(");
		appendArgumentTo(sb);
		sb.append(")");
	}

	/**
	 * JavaScript コンストラクタツリーを生成するために呼び出される(called)。
	 * @param sb 作成途中の JavaScript コンストラクタツリーの文字列表現。
	 */
	abstract public void appendArgumentTo(final Appendable sb) throws IOException;

	public void addMessageTo(final Collection<String> messageCollection) {
	}
}
