/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.action;

import java.util.Arrays;
import java.util.Iterator;

import junit.framework.TestCase;
import woolpack.action.ActionDef;
import woolpack.action.ForwardDef;
import woolpack.action.ActionConstants;
import woolpack.utils.OGE;

public class ActionDefTest extends TestCase {
	
	public void testConstructor(){
		try{
			new ActionDef(null, OGE.NULL, new ForwardDef("forwardId0", OGE.NULL, ActionConstants.ANY));
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new ActionDef(OGE.NULL, (OGE)null, new ForwardDef("forwardId0", OGE.NULL, ActionConstants.ANY));
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new ActionDef(OGE.NULL, OGE.NULL, (Iterable<ForwardDef>)null);
			fail();
		}catch(final NullPointerException expected){
		}
	}
	
	public void testGet(){
		final ForwardDef forwardDef = new ForwardDef("forwardId0", OGE.NULL, ActionConstants.ANY);
		final ActionDef def = new ActionDef(new OGE("method0"), forwardDef);
		assertEquals(OGE.NULL, def.getComponentOGE());
		assertEquals(new OGE("method0"), def.getMethodOGE());
		final Iterator<ForwardDef> iterator = def.getForwardDefIterable().iterator();
		assertTrue(iterator.hasNext());
		assertEquals(forwardDef, iterator.next());
		assertFalse(iterator.hasNext());
	}
	
	public void testGet2(){
		final ForwardDef forwardDef = new ForwardDef("forwardId0", OGE.NULL, ActionConstants.ANY);
		final ActionDef def = new ActionDef(new OGE("method0"), Arrays.asList(forwardDef));
		assertEquals(OGE.NULL, def.getComponentOGE());
		assertEquals(new OGE("method0"), def.getMethodOGE());
		final Iterator<ForwardDef> iterator = def.getForwardDefIterable().iterator();
		assertTrue(iterator.hasNext());
		assertEquals(forwardDef, iterator.next());
		assertFalse(iterator.hasNext());
	}
}
