/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.config;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ConfigAllTests extends TestCase {

	public static Test suite() {
		TestSuite suite = new TestSuite();
		suite.addTest(new TestSuite(CacheMapTest.class));
		suite.addTest(new TestSuite(ConfigConstantsTest.class));
		suite.addTest(new TestSuite(ConfigContextTest.class));
		suite.addTest(new TestSuite(ConfigCountTest.class));
		suite.addTest(new TestSuite(ConfigSerialTest.class));
		suite.addTest(new TestSuite(CopyConfigContextTest.class));
		suite.addTest(new TestSuite(PutResourceBundleTest.class));
		suite.addTest(new TestSuite(RemoveNotResolvedTest.class));
		suite.addTest(new TestSuite(ResolveEmbeddingTest.class));
		suite.addTest(new TestSuite(ToLinkedHashMapTest.class));
		return suite;
	}
}
