/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import java.util.regex.Pattern;

import junit.framework.TestCase;

public class RegExpIdTest extends TestCase {

	public void testConstructor(){
		try{
			new RegExpId((Pattern)null, DomConstants.NULL, DomConstants.NULL);
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new RegExpId((String)null, DomConstants.NULL, DomConstants.NULL);
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new RegExpId("a", null, DomConstants.NULL);
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new RegExpId("a", DomConstants.NULL, null);
			fail();
		}catch(final NullPointerException expected){
		}
	}
	
	public void testTrueExpression(){
		final Count counter0 = new Count(DomConstants.NULL);
		final DomExpression expression = new RegExpId("a", counter0);
		final DomContext context = new DomContext();
		
		context.setId("b");
		expression.interpret(context);
		assertEquals(0, counter0.getCount());
		
		context.setId("a");
		expression.interpret(context);
		assertEquals(1, counter0.getCount());
	}
	
	public void testFalseExpression(){
		final Count counter0 = new Count(DomConstants.NULL);
		final Count counter1 = new Count(DomConstants.NULL);
		final DomExpression expression = new RegExpId("a", counter0, counter1);
		final DomContext context = new DomContext();
		
		context.setId("b");
		expression.interpret(context);
		assertEquals(0, counter0.getCount());
		assertEquals(1, counter1.getCount());
		
		context.setId("a");
		expression.interpret(context);
		assertEquals(1, counter0.getCount());
		assertEquals(1, counter1.getCount());
	}
}
