/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import javax.xml.xpath.XPathExpressionException;

import junit.framework.TestCase;
import woolpack.TestUtils;
import woolpack.utils.OGE;

public class XPathAttrValueTest extends TestCase {

	public void testConstructor(){
		try{
			new XPathAttrValue(null, "value", DomConstants.NULL, DomConstants.NULL);
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new XPathAttrValue("", "value", DomConstants.NULL, DomConstants.NULL);
			fail();
		}catch(final RuntimeException expected){
			assertTrue(expected.getCause() instanceof XPathExpressionException);
		}
		try{
			new XPathAttrValue("value", null, DomConstants.NULL, DomConstants.NULL);
			fail();
		}catch(final NullPointerException expected){
		}
	}
	
	public void testAttrValueEmpty(){
		final DomExpression expression = new Serial(
			TestUtils.getToNodeForm("<INPUT type=\"text\" name=\"name0\" value=\"\" />"),
			new XPathAttrValue("value", "", new UpdateAttrValue("value", new OGE("\"value1\""))));
		final DomContext context = new DomContext();
		expression.interpret(context);

		assertTrue(TestUtils.equalsForm(context, "<INPUT type=\"text\" name=\"name0\" value=\"value1\" />"));
	}
	
	public void testFirstExpressionNull(){
		try{
			new XPathAttrValue("value", "value", null, DomConstants.NULL);
			fail();
		}catch(final NullPointerException expected){
		}
	}
	
	public void testOtherExpressionNull(){
		try{
			new XPathAttrValue("value", "value", DomConstants.NULL, null);
			fail();
		}catch(final NullPointerException expected){
		}
	}
	
	public void testNormal(){
		final DomExpression expression = new Serial(
			TestUtils.getToNodeForm("<INPUT type=\"text\" name=\"name0\" value=\"value0\" />"),
			new XPathAttrValue("name", "name0", new UpdateAttrValue("value", new OGE("\"value1\""))));
		final DomContext context = new DomContext();
		expression.interpret(context);

		assertTrue(TestUtils.equalsForm(context, "<INPUT type=\"text\" name=\"name0\" value=\"value1\" />"));
	}
}
