/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.locale;

import java.util.HashMap;
import java.util.Locale;

import junit.framework.TestCase;
import woolpack.text.CloneFormatFactory;
import woolpack.text.FixFormat;
import woolpack.text.FormatFactory;
import woolpack.utils.MapBuilder;

public class LocaleFormatFactoryTest extends TestCase {

	public void testConstructor(){
		try{
			new LocaleFormatFactory(null, new ThreadLocal<Locale>());
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new LocaleFormatFactory(new HashMap<Locale,FormatFactory>(), null);
			fail();
		}catch(final NullPointerException expected){
		}
	}
	
	public void testNormal(){
		final ThreadLocal<Locale> threadLocal = new ThreadLocal<Locale>();
		final FormatFactory factory = new LocaleFormatFactory(new MapBuilder<Locale,FormatFactory>()
				.put(Locale.JAPANESE, new CloneFormatFactory(new FixFormat("j")))
				.put(Locale.ENGLISH, new CloneFormatFactory(new FixFormat("e")))
				.put(null, new CloneFormatFactory(new FixFormat("n")))
				.getMap(), threadLocal);
		
		threadLocal.set(Locale.JAPANESE);
		assertEquals("j", factory.newInstance().format("a"));
		
		threadLocal.set(Locale.ENGLISH);
		assertEquals("e", factory.newInstance().format("a"));
		
		threadLocal.set(null);
		assertEquals("n", factory.newInstance().format("a"));
	}
}
