/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.text;

import java.text.DecimalFormat;
import java.text.Format;
import java.text.ParseException;

import junit.framework.TestCase;

public class ToDoubleFormatTest extends TestCase {

	public void testConstructor(){
		try{
			new ToDoubleFormat(null);
			fail();
		}catch(final NullPointerException e){
		}
	}
	
	private void scenario(final Format format) throws ParseException{
		assertEquals("1", format.format(new Double(1)));
		assertEquals(new Double(1), format.parseObject("1"));
		assertEquals(new Double(Double.MAX_VALUE), format.parseObject(String.valueOf(Double.MAX_VALUE)));
		assertEquals(new Double(Double.MIN_VALUE), format.parseObject(String.valueOf(Double.MIN_VALUE)));
		assertEquals(new Double(1.5), format.parseObject("1.5"));
		
		try{
			format.parseObject("a");
			fail();
		}catch(final ParseException e){
		}
	}

	public void testNormal() throws ParseException{
		final Format format0 = new ToDoubleFormat();
		scenario(format0);
		final Format format1 = (Format)format0.clone();
		assertTrue(format0 != format1);
		scenario(format1);
	}

	public void testNormal2() throws ParseException{
		final Format format0 = new ToDoubleFormat(new DecimalFormat());
		scenario(format0);
		final Format format1 = (Format)format0.clone();
		assertTrue(format0 != format1);
		scenario(format1);
	}
}
