/*
 * Decompiled with CFR 0.152.
 */
package woolpack.el.convert;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import woolpack.utils.MapBuilder;

abstract class NumberConverter {
    private static final Map<Class, NumberConverter> MAP = MapBuilder.get(new HashMap()).put(Byte.class, new NumberConverter(){

        Number convertLocal(Number old) {
            return new Byte(old.byteValue());
        }
    }).put(Short.class, new NumberConverter(){

        Number convertLocal(Number old) {
            return new Short(old.shortValue());
        }
    }).put(Integer.class, new NumberConverter(){

        Number convertLocal(Number old) {
            return new Integer(old.intValue());
        }
    }).put(Long.class, new NumberConverter(){

        Number convertLocal(Number old) {
            return new Long(old.longValue());
        }
    }).put(Float.class, new NumberConverter(){

        Number convertLocal(Number old) {
            return new Float(old.floatValue());
        }
    }).put(Double.class, new NumberConverter(){

        Number convertLocal(Number old) {
            return new Double(old.doubleValue());
        }
    }).put(BigInteger.class, new NumberConverter(){

        Number convertLocal(Number old) {
            return BigInteger.valueOf(old.longValue());
        }
    }).put(BigDecimal.class, new NumberConverter(){

        Number convertLocal(Number old) {
            return new BigDecimal(old.doubleValue());
        }
    }).get();

    NumberConverter() {
    }

    abstract Number convertLocal(Number var1);

    static Number convert(Number old, Class toType) {
        if (toType.equals(old.getClass())) {
            return old;
        }
        return MAP.get(toType).convertLocal(old);
    }
}

