/*
 * Decompiled with CFR 0.152.
 */
package woolpack.el.convert;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import woolpack.el.ELTargetRuntimeException;
import woolpack.el.convert.ConvertConstants;
import woolpack.el.convert.Convertable;
import woolpack.el.convert.FormatConverter;
import woolpack.el.convert.NumberConverter;
import woolpack.el.convert.ParseConverter;
import woolpack.text.BooleanFormat;
import woolpack.text.ToCharacterFormat;
import woolpack.text.ToSQLDateFormat;
import woolpack.text.ToStringFormat;
import woolpack.utils.SwitchBuilder;
import woolpack.utils.Switchable;

public class SimpleConverter
implements Convertable {
    private final Switchable<Class, Convertable> parseSwitchable;
    private final NumberFormat numberFormat;
    private final DateFormat dateFormat;
    private final BooleanFormat booleanFormat;

    public SimpleConverter(final NumberFormat numberFormat, DateFormat dateFormat, BooleanFormat booleanFormat) {
        numberFormat.getClass();
        this.numberFormat = numberFormat;
        this.dateFormat = dateFormat;
        this.booleanFormat = booleanFormat;
        this.parseSwitchable = new SwitchBuilder<Class<String>, 1>().put(String.class, new Convertable(booleanFormat, dateFormat, numberFormat){
            private final Switchable<Class, Convertable> formatSwitchable;
            {
                this.formatSwitchable = new SwitchBuilder<Class<Boolean>, FormatConverter>().put(Boolean.class, new FormatConverter(booleanFormat)).put(java.util.Date.class, new FormatConverter(dateFormat)).put(Number.class, new FormatConverter(numberFormat)).put(Byte.class).put(Short.class).put(Integer.class).put(Long.class).put(Float.class).put(Double.class).put(BigInteger.class).put(BigDecimal.class).get(new FormatConverter(new ToStringFormat()));
            }

            public Object convert(Object beforeValue, Class toType, String propertyName) {
                return this.formatSwitchable.get(beforeValue.getClass()).convert(beforeValue, toType, propertyName);
            }
        }).put(Boolean.class, (Object)new ParseConverter(booleanFormat)).put(Character.class, (Object)new ParseConverter(new ToCharacterFormat())).put(Date.class, (Object)new ParseConverter(new ToSQLDateFormat(dateFormat))).put(java.util.Date.class, (Object)new ParseConverter(dateFormat)).put(Number.class, new Convertable(){

            public Object convert(Object beforeValue, Class toType, String propertyName) {
                Number number;
                if (Number.class.isAssignableFrom(beforeValue.getClass())) {
                    number = (Number)beforeValue;
                } else {
                    try {
                        number = numberFormat.parse(beforeValue.toString());
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                }
                return NumberConverter.convert(number, toType);
            }
        }).put(Byte.class).put(Short.class).put(Integer.class).put(Long.class).put(Float.class).put(Double.class).put(BigInteger.class).put(BigDecimal.class).get(ConvertConstants.ECHO);
    }

    public Object convert(Object beforeValue, Class toType, String propertyName) throws ELTargetRuntimeException {
        return this.parseSwitchable.get(toType).convert(beforeValue, toType, propertyName);
    }

    public BooleanFormat getBooleanFormat() {
        return this.booleanFormat;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }
}

