/*
 * Decompiled with CFR 0.152.
 */
package woolpack.locale;

import java.util.Collection;
import java.util.Locale;
import woolpack.utils.Switchable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocaleConstants {
    private LocaleConstants() {
    }

    private static int calcLocaleCount(Locale key) {
        return key.getVariant() != null && key.getVariant().length() > 0 ? 3 : (key.getCountry() != null && key.getCountry().length() > 0 ? 2 : 1);
    }

    public static <V> Switchable<Locale, V> nearLocaleSwitch(final Switchable<Locale, V> switchable) {
        return new Switchable<Locale, V>(){

            @Override
            public V get(Locale key) {
                if (switchable.keys().contains(key)) {
                    return switchable.get(key);
                }
                if (key == null) {
                    return switchable.getDefault();
                }
                int keyCount = LocaleConstants.calcLocaleCount(key);
                Locale l0 = null;
                int count0 = 0;
                for (Locale l1 : switchable.keys()) {
                    if (keyCount < LocaleConstants.calcLocaleCount(l1)) continue;
                    int count1 = 0;
                    if (key.getLanguage() != null && key.getLanguage().equals(l1.getLanguage())) {
                        ++count1;
                        if (key.getCountry() != null && key.getCountry().equals(l1.getCountry())) {
                            ++count1;
                        }
                    }
                    if (count0 >= count1) continue;
                    count0 = count1;
                    l0 = l1;
                }
                if (l0 == null) {
                    return switchable.getDefault();
                }
                return switchable.get(l0);
            }

            @Override
            public Collection<Locale> keys() {
                return switchable.keys();
            }

            @Override
            public V getDefault() {
                return switchable.getDefault();
            }
        };
    }
}

