/*
 * Decompiled with CFR 0.152.
 */
package woolpack.text;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Map;
import woolpack.utils.UtilsConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimitedValueFormat
extends Format {
    private static final long serialVersionUID = 1L;
    private final Map<String, ? extends Object> parseMap;
    private final Object defaultParsedValue;
    private final String defaultFormattedValue;
    private final Map<? extends Object, String> formatMap;

    protected LimitedValueFormat(LimitedValueFormat format) {
        this.parseMap = format.parseMap;
        this.defaultParsedValue = format.defaultParsedValue;
        this.defaultFormattedValue = format.defaultFormattedValue;
        this.formatMap = format.formatMap;
    }

    public LimitedValueFormat(Map<String, ? extends Object> parseMap, Object defaultParsedValue, String defaultFormattedValue) {
        this.parseMap = new HashMap<String, Object>(parseMap);
        this.defaultParsedValue = defaultParsedValue;
        this.defaultFormattedValue = defaultFormattedValue;
        this.formatMap = UtilsConstants.inverseMap(parseMap);
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        int start = toAppendTo.length();
        String o = this.formatMap.get(obj);
        if (o == null) {
            o = this.defaultFormattedValue;
        }
        if (o != null) {
            toAppendTo.append(o);
        } else {
            toAppendTo.append(obj);
        }
        pos.setBeginIndex(start);
        pos.setEndIndex(toAppendTo.length());
        return toAppendTo;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        for (String key : this.parseMap.keySet()) {
            if (!source.startsWith(key, pos.getIndex())) continue;
            pos.setIndex(pos.getIndex() + key.length());
            return this.parseMap.get(key);
        }
        if (this.defaultParsedValue != null) {
            pos.setIndex(source.length());
            return this.defaultParsedValue;
        }
        pos.setErrorIndex(pos.getIndex());
        return null;
    }

    @Override
    public Object clone() {
        return new LimitedValueFormat(this);
    }

    public String getDefaultFormattedValue() {
        return this.defaultFormattedValue;
    }

    public Object getDefaultParsedValue() {
        return this.defaultParsedValue;
    }

    public Map<String, ? extends Object> getParseMap() {
        return this.parseMap;
    }
}

