/*
 * Decompiled with CFR 0.152.
 */
package woolpack.visitor;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import woolpack.dom.DomConstants;
import woolpack.visitor.Acceptable;
import woolpack.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomVisitorConstants {
    public static final Acceptable<Object> OBJECT = new Acceptable<Object>(){

        @Override
        public void accept(Visitor visitor, Object v) {
            Node node = (Node)visitor.getContext();
            node.appendChild(DomConstants.getDocumentNode(node).createTextNode(v.toString()));
        }
    };
    public static final Acceptable<Iterable> ITERABLE_COMMA = new Acceptable<Iterable>(){

        @Override
        public void accept(Visitor visitor, Iterable v) {
            boolean flag = true;
            for (Object e : v) {
                if (flag) {
                    flag = false;
                } else {
                    visitor.visit(", ");
                }
                visitor.visit(e);
            }
        }
    };

    private DomVisitorConstants() {
    }

    public static final <V> Acceptable<V> addElementAcceptable(final String elementName, final Acceptable<V> child) {
        return new Acceptable<V>(){

            @Override
            public void accept(Visitor visitor, V v) {
                Element node = (Element)visitor.getContext();
                Element element = DomConstants.getDocumentNode(node).createElement(elementName);
                node.appendChild(element);
                Visitor newVisitor = visitor.copy();
                newVisitor.setContext(element);
                child.accept(newVisitor, v);
            }
        };
    }
}

