/*
 * Decompiled with CFR 0.152.
 */
package woolpack.visitor;

import java.util.Map;
import woolpack.utils.Switchable;
import woolpack.visitor.Acceptable;
import woolpack.visitor.DomVisitorConstants;
import woolpack.visitor.Visitor;
import woolpack.visitor.VisitorConstants;

public class HtmlVisitorConstants {
    public static final Acceptable<Switchable> SWITCH = DomVisitorConstants.addElementAcceptable("dl", new Acceptable<Switchable>(){
        private Acceptable<Object> keyAcceptable = DomVisitorConstants.addElementAcceptable("dt", VisitorConstants.ECHO);
        private Acceptable<Object> valueAcceptable = DomVisitorConstants.addElementAcceptable("dd", VisitorConstants.ECHO);

        @Override
        public void accept(Visitor visitor, Switchable v) {
            for (Object e : v.keys()) {
                this.keyAcceptable.accept(visitor, e);
                this.valueAcceptable.accept(visitor, v.get(e));
            }
            if (v.getDefault() != null) {
                this.keyAcceptable.accept(visitor, "\u30c7\u30d5\u30a9\u30eb\u30c8");
                this.valueAcceptable.accept(visitor, v.getDefault());
            }
        }
    });
    public static final Acceptable<Iterable> ITERABLE = DomVisitorConstants.addElementAcceptable("ol", new Acceptable<Iterable>(){
        private Acceptable<Object> acceptable = DomVisitorConstants.addElementAcceptable("li", VisitorConstants.ECHO);

        @Override
        public void accept(Visitor visitor, Iterable v) {
            for (Object e : v) {
                this.acceptable.accept(visitor, e);
            }
        }
    });
    public static final Acceptable<Object> BLOCK = DomVisitorConstants.addElementAcceptable("div", VisitorConstants.ECHO);
    public static final Acceptable<Map> MAP = DomVisitorConstants.addElementAcceptable("dl", new Acceptable<Map>(){
        private Acceptable<Object> keyAcceptable = DomVisitorConstants.addElementAcceptable("dt", VisitorConstants.ECHO);
        private Acceptable<Object> valueAcceptable = DomVisitorConstants.addElementAcceptable("dd", VisitorConstants.ECHO);

        @Override
        public void accept(Visitor visitor, Map v) {
            for (Object e : v.keySet()) {
                this.keyAcceptable.accept(visitor, e);
                this.valueAcceptable.accept(visitor, v.get(e));
            }
        }
    });

    private HtmlVisitorConstants() {
    }
}

