/*
 * Decompiled with CFR 0.152.
 */
package woolpack.visitor;

import java.beans.PropertyDescriptor;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import woolpack.utils.Switchable;
import woolpack.visitor.Acceptable;
import woolpack.visitor.Visitor;
import woolpack.visitor.VisitorConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsVisitorConstants {
    private static final Pattern LOCAL_CLASS_NAME = Pattern.compile("([^\\.]+\\.)*([^\\.]*)");
    public static final Acceptable<Object> PARAMS = new Acceptable<Object>(){

        @Override
        public void accept(Visitor visitor, Object v) {
            StringBuilder sb = (StringBuilder)visitor.getContext();
            boolean firstFlag = true;
            List<PropertyDescriptor> methodList = VisitorConstants.getConstructorGetterList(v.getClass());
            for (PropertyDescriptor property : methodList) {
                Object value = VisitorConstants.get(v, property.getReadMethod());
                if (firstFlag) {
                    firstFlag = false;
                } else {
                    sb.append(',');
                }
                visitor.visit(value);
            }
        }
    };
    public static final Acceptable<Iterable> ITERABLE = new Acceptable<Iterable>(){

        @Override
        public void accept(Visitor visitor, Iterable v) {
            StringBuilder sb = (StringBuilder)visitor.getContext();
            sb.append('[');
            boolean flag = true;
            for (Object o : v) {
                if (flag) {
                    flag = false;
                } else {
                    sb.append(',');
                }
                visitor.visit(o);
            }
            sb.append(']');
        }
    };
    public static final Acceptable<Object> OBJECT = new Acceptable<Object>(){

        @Override
        public void accept(Visitor visitor, Object v) {
            StringBuilder sb = (StringBuilder)visitor.getContext();
            sb.append(v);
        }
    };
    public static final Acceptable<Map> MAP = new Acceptable<Map>(){

        @Override
        public void accept(Visitor visitor, Map v) {
            StringBuilder sb = (StringBuilder)visitor.getContext();
            sb.append('{');
            boolean flag = true;
            for (Object key : v.keySet()) {
                if (flag) {
                    flag = false;
                } else {
                    sb.append(',');
                }
                visitor.visit(key);
                sb.append(':');
                visitor.visit(v.get(key));
            }
            sb.append('}');
        }
    };

    private JsVisitorConstants() {
    }

    public static final <V> Acceptable<V> objectAcceptable(final Object object) {
        return new Acceptable<V>(){

            @Override
            public void accept(Visitor visitor, V v) {
                StringBuilder sb = (StringBuilder)visitor.getContext();
                sb.append(object);
            }
        };
    }

    public static final <V> Acceptable<V> classNameAcceptable(final Acceptable<V> child) {
        return new Acceptable<V>(){

            @Override
            public void accept(Visitor visitor, V v) {
                StringBuilder sb = (StringBuilder)visitor.getContext();
                sb.append("new ");
                sb.append(JsVisitorConstants.getLocalClassName(v.getClass()));
                sb.append('(');
                child.accept(visitor, v);
                sb.append(')');
            }
        };
    }

    public static <K, V> Acceptable<Switchable<K, V>> switchableAcceptable(final Object defaultKey) {
        return new Acceptable<Switchable<K, V>>(){

            @Override
            public void accept(Visitor visitor, Switchable<K, V> v) {
                StringBuilder sb = (StringBuilder)visitor.getContext();
                sb.append('{');
                boolean flag = true;
                for (Object key : v.keys()) {
                    if (flag) {
                        flag = false;
                    } else {
                        sb.append(',');
                    }
                    visitor.visit(key);
                    sb.append(':');
                    visitor.visit(v.get(key));
                }
                if (defaultKey != null && v.getDefault() != null) {
                    if (flag) {
                        flag = false;
                    } else {
                        sb.append(',');
                    }
                    visitor.visit(defaultKey);
                    sb.append(':');
                    visitor.visit(v.getDefault());
                }
                sb.append('}');
            }
        };
    }

    public static String getLocalClassName(Class clazz) {
        Matcher m = LOCAL_CLASS_NAME.matcher(clazz.getName());
        m.matches();
        return m.group(2);
    }

    public static final Acceptable<Object> escapeStringAcceptable(final Acceptable<Object> child) {
        return new Acceptable<Object>(){
            private final Pattern pattern_t = Pattern.compile("\\t");
            private final Pattern pattern_n = Pattern.compile("\\n");
            private final Pattern pattern_r = Pattern.compile("\\r");
            private final Pattern pattern_f = Pattern.compile("\\f");
            private final Pattern pattern_a = Pattern.compile("\\a");
            private final Pattern pattern_e = Pattern.compile("\\e");

            @Override
            public void accept(Visitor visitor, Object v) {
                String s = v.toString();
                s = this.pattern_t.matcher(s).replaceAll("\\t");
                s = this.pattern_n.matcher(s).replaceAll("\\n");
                s = this.pattern_r.matcher(s).replaceAll("\\r");
                s = this.pattern_f.matcher(s).replaceAll("\\f");
                s = this.pattern_a.matcher(s).replaceAll("\\a");
                s = this.pattern_e.matcher(s).replaceAll("\\e");
                child.accept(visitor, String.valueOf('\"') + s + '\"');
            }
        };
    }
}

