/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.adapter;

import java.lang.reflect.Member;
import java.util.Map;

import ognl.TypeConverter;
import woolpack.el.ELTargetRuntimeException;
import woolpack.el.convert.CollectionConverter;
import woolpack.el.convert.Convertable;
import woolpack.el.convert.DelegationIfNecessityConverter;

/**
 * 一覧を表すオブジェクトを変換する OGNL 用型コンバータ。
 * 本クラスは OGNL のライブラリを使用する。
 * 適用しているパターン：Adapter。
 * @author nakamura
 *
 */
class OgnlCollectionTypeConverter implements TypeConverter {
	private final TypeConverter converter;
	
	/**
	 * コンストラクタ。
	 * @param converter 単純型の変換器。
	 * @throws NullPointerException 引数が null の場合。
	 */
	OgnlCollectionTypeConverter(final TypeConverter converter){
		converter.getClass();
		this.converter = converter;
	}
	
	/**
	 * OGNL の API から呼び出される。(called)。
	 * @param context OGNL のコンテキスト。
	 * @param target 格納先のオブジェクト。
	 * @param member 不明。
	 * @param propertyName 変換元のプロパティ名。
	 * @param beforeValue 変換前のオブジェクト。
	 * @param toType 変換先の型。
	 * @return 変換後のオブジェクト。
	 */
	public Object convertValue(
			final Map context, 
			final Object target, 
			final Member member, 
			final String propertyName, 
			final Object beforeValue, 
			final Class toType) {
		return new DelegationIfNecessityConverter(new CollectionConverter(new Convertable(){
			public Object convert(final Object inner_beforeValue, final Class inner_toType, final String inner_propertyName) throws ELTargetRuntimeException {
				return converter.convertValue(context, target, member, 
						inner_propertyName, inner_beforeValue, inner_toType);
			}
		})).convert(beforeValue, toType, propertyName);
	}
}
