/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import woolpack.utils.Switchable;
import woolpack.utils.UtilsConstants;

/**
 * {@link Evaluable#eval(DomContext)}の返却値で委譲先を分岐する{@link DomExpression}。
 * 適用しているパターン：フィルタ。
 * @author nakamura
 * 
 * @param <V> 評価結果。
 */
public class Branch<V> implements DomExpression {
	private final Evaluable<V> eval;
	private final Switchable<V,DomExpression> switchable;
	
	/**
	 * コンストラクタ。
	 * @param eval 評価器。
	 * @param switchable 評価結果と委譲先の{@link Switchable}。
	 * @throws NullPointerException 引数のいずれかが null の場合。
	 */
	public Branch(final Evaluable<V> eval, final Switchable<V,DomExpression> switchable){
		eval.getClass();
		switchable.getClass();
		
		this.eval = eval;
		this.switchable = UtilsConstants.nullToDefaultSwitchIfAbsent(DomConstants.NULL, switchable);
	}

	public void interpret(final DomContext context) {
		switchable.get(eval.eval(context)).interpret(context);
	}
}
