/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import org.w3c.dom.Element;

/**
 * {@link DomContext#getNode()}の親ノードとして DOM エレメントを挿入する{@link DomExpression}。
 * 適用しているパターン：Proxy。
 * @author nakamura
 *
 */
public class InsertElementToParent implements DomExpression {
	private final String elementName;
	private final DomExpression expression;
	
	/**
	 * コンストラクタ。
	 * @param elementName エレメント名。
	 * @throws NullPointerException 引数が null の場合。
	 * @throws StringIndexOutOfBoundsException 引数が空の場合。
	 */
	public InsertElementToParent(final String elementName){
		this(elementName, DomConstants.NULL);
	}
	
	/**
	 * コンストラクタ。
	 * @param elementName エレメント名。
	 * @param expression 挿入後の委譲先。
	 * @throws NullPointerException 引数のいずれかが null の場合。
	 * @throws StringIndexOutOfBoundsException elementName が空の場合。
	 */
	public InsertElementToParent(final String elementName, final DomExpression expression){
		elementName.charAt(0);
		expression.getClass();
		
		this.elementName = elementName;
		this.expression = expression;
	}

	/**
	 * @throws NullPointerException 引数または{@link DomContext#getNode()}が null の場合。
	 * @throws ClassCastException {@link DomContext#getNode()}が{@link Element}でない場合。
	 */
	public void interpret(final DomContext context) {
		final Element element = DomConstants.getDocumentNode(context.getNode()).createElement(elementName);
		context.getNode().getParentNode().insertBefore(element,context.getNode());
		element.appendChild(context.getNode());
		
		final DomContext newContext = context.copy();
		newContext.setNode(element);
		expression.interpret(newContext);
	}
}
