/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import java.util.Arrays;

/**
 * {@link DomExpression}の一覧を順次実行する{@link DomExpression}。
 * @author nakamura
 *
 */
public class Serial implements DomExpression {
	private final Iterable<? extends DomExpression> iterable;

	/**
	 * コンストラクタ。
	 * @param iterable {@link DomExpression}の一覧。本クラスはこの引数の状態を変化させない。ステートレスであるべき。
	 * @throws NullPointerException 引数が null の場合。
	 */
	public Serial(final Iterable<? extends DomExpression> iterable){
		iterable.getClass();
		this.iterable = iterable;
	}
	
	/**
	 * コンストラクタ。
	 * @param domExpressions {@link DomExpression}の一覧。本クラスはこの引数の状態を変化させない。ステートレスであるべき。
	 */
	public Serial(final DomExpression... domExpressions){
		this(Arrays.asList(domExpressions));
	}

	public void interpret(final DomContext context) {
		for(final DomExpression e:iterable){
			e.interpret(context);
		}
	}
}
