/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.ee;

import woolpack.config.ConfigContext;
import woolpack.config.ConfigExpression;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;

/**
 * 委譲先の{@link ConfigExpression}を実行し
 * 生成された{@link java.util.Map}を{@link DomContext#getConfig()}に設定する{@link DomExpression}。
 * 適用しているパターン：Adapter。
 * @author nakamura
 *
 */
public class ConfigDomExpression implements DomExpression {
	private final ConfigExpression configExpression;

	/**
	 * コンストラクタ。
	 * @param configExpression 委譲先。
	 * @throws NullPointerException 引数が null の場合。
	 */
	public ConfigDomExpression(final ConfigExpression configExpression){
		configExpression.getClass();
		this.configExpression = configExpression;
	}
	
	/**
	 * @throws NullPointerException 引数が null の場合。
	 */
	public void interpret(final DomContext domContext) {
		final ConfigContext configContext = new ConfigContext();
		configExpression.interpret(configContext);
		domContext.setConfig(configContext.getMap());
	}
}
