/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.ee;

import java.io.IOException;
import java.io.InputStream;

import javax.servlet.ServletContext;

import woolpack.utils.InputStreamFactory;

/**
 * {@link ServletContext#getResourceAsStream(java.lang.String)}を使用して{@link InputStream}を取得する{@link InputStreamFactory}。
 * 本クラスは Servlet API のライブラリを使用する。
 * 適用しているパターン：Adapter。
 * @author nakamura
 *
 */
public class ServletInputStreamFactory implements InputStreamFactory {
	private final ServletContext context;
	
	/**
	 * コンストラクタ。
	 * @param context サーブレットのコンテキスト。
	 * @throws NullPointerException 引数が null の場合。
	 */
	public ServletInputStreamFactory(final ServletContext context){
		context.getClass();
		this.context = context;
	}

	public InputStream newInstance(final String id) throws IOException {
		return context.getResourceAsStream(id);
	}
}
