/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;


/**
 * 値取得と作用のための式言語を表す。
 * 実装クラスの各インスタンスはイミュータブルであるべき。
 * 適用しているパターン：Interpreter(Expression 役(対応する Context 役クラスは存在しない))。
 * @author nakamura
 *
 */
public interface GettingEL {
	
	/**
	 * 基点に対し言語を作用させ、結果を変換して返す。
	 * @param root 基点。
	 * @param toType 変換先の型。実装ではこのパラメータが動作に反映されない可能性がある。
	 * @return 実行結果の値。
	 * @throws ELTargetRuntimeException 呼び出し先メソッドがエラーを投げた場合。
	 */
	public Object getValue(Object root, Class toType) throws ELTargetRuntimeException;

	/**
	 * 基点に対し言語を作用させ、結果を返す。
	 * @param root 基点。
	 * @return 実行結果の値。
	 * @throws ELTargetRuntimeException 呼び出し先メソッドがエラーを投げた場合。
	 */
	public Object getValue(Object root) throws ELTargetRuntimeException;
}
