/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el.convert;

import java.util.Arrays;

import woolpack.utils.UtilsConstants;

/**
 * {@link Convertable}の一覧を順次実行する{@link Convertable}。
 * @author nakamura
 *
 */
public class SerialConverter implements Convertable{
	private final Iterable<Convertable> iterable;
	
	/**
	 * コンストラクタ。
	 * @param iterable {@link Convertable}の一覧。本クラスはこの引数の状態を変化させない。ステートレスであるべき。
	 * @throws NullPointerException 引数が null の場合。
	 */
	public SerialConverter(final Iterable<Convertable> iterable){
		iterable.getClass();
		this.iterable = iterable;
	}
	
	/**
	 * コンストラクタ。
	 * @param array {@link Convertable}の一覧。本クラスはこの引数の状態を変化させない。ステートレスであるべき。
	 * @throws NullPointerException 引数が null の場合。
	 */
	public SerialConverter(final Convertable... array){
		this(Arrays.asList(array));
	}

	public Object convert(final Object beforeValue, final Class toType, final String propertyName) {
		Object o = beforeValue;
		for(final Convertable c:iterable){
			o = c.convert(o, toType, propertyName);
		}
		return o;
	}

	public Iterable<Convertable> getIterable() {
		return UtilsConstants.unmodifiableIterable(iterable);
	}
}
