/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.test;

import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;

/**
 * {@link Runnable}に委譲する{@link DomExpression}。
 * 適用しているパターン：Adapter。
 * @author nakamura
 *
 */
public class RunnableDomExpression implements DomExpression {
	private final Runnable runnable;
	
	/**
	 * コンストラクタ。
	 * @param runnable 委譲先。
	 * @throws NullPointerException 引数が null の場合。
	 */
	public RunnableDomExpression(final Runnable runnable){
		runnable.getClass();
		this.runnable = runnable;
	}

	public void interpret(final DomContext context) {
		runnable.run();
	}
}
