/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import woolpack.dom.DomContext;
import woolpack.utils.Switchable;
import woolpack.utils.UtilsConstants;

/**
 * id で委譲先を分岐する{@link ValidatorExpression}。
 * {@link ValidatorContext}に対して状態を変更する操作を行わない。
 * 適用しているパターン：フィルタ。
 * @author nakamura
 *
 */
public class BranchByIdValidator extends BranchValidator{
	
	/**
	 * コンストラクタ。
	 * @param switchable idと{@link ValidatorExpression}の{@link Switchable}。
	 * @throws NullPointerException 引数が null の場合。
	 */
	public BranchByIdValidator(final Switchable<String,ValidatorExpression> switchable){
		super(UtilsConstants.nullToDefaultSwitchIfAbsent(ValidatorConstants.TRUE, switchable));
	}

	/**
	 * @throws NullPointerException 引数または{@link DomContext#getId()}または{@link ValidatorContext#getId()}に対応する値が null の場合。
	 */
	@Override public boolean interpret(final ValidatorContext context) {
		return getSwitchable().get(context.getId()).interpret(context);
	}
}
