/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;


/**
 * 文字列の最小文字数を検証してその結果を返す{@link ValidatorExpression}。
 * {@link ValidatorContext}に対して状態を変更する操作を行わない。
 * @author nakamura
 *
 */
public class MinLengthValidator implements ValidatorExpression {
	private final int value;
	
	/**
	 * コンストラクタ。
	 * @param value 最小文字数。
	 * @throws NullPointerException 引数が null の場合。
	 */
	public MinLengthValidator(final int value){
		this.value = value;
		if(this.value <= 0){
			throw new IllegalArgumentException("value must equals or more than 0.");
		}
	}

	/**
	 * @throws NullPointerException 引数または{@link ValidatorContext#getTmpValue()}が null の場合。
	 * @throws ClassCastException {@link ValidatorContext#getTmpValue()}が文字列でない場合。
	 */
	public boolean interpret(final ValidatorContext context) {
		return ((String)context.getTmpValue()).length() >= value;
	}

	public int getValue() {
		return value;
	}
}
