/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

/**
 * 委譲先の検証結果を否定する{@link ValidatorExpression}。
 * {@link ValidatorContext}に対して状態を変更する操作を行わない。
 * 適用しているパターン：Decorator。
 * @author nakamura
 *
 */
public class NotValidator extends DelegationValidator {

	/**
	 * コンストラクタ。
	 * @param expression 委譲先。
	 * @throws NullPointerException 引数が null の場合。
	 */
	public NotValidator(final ValidatorExpression expression){
		super(expression);
	}
	
	@Override public boolean interpret(final ValidatorContext context) {
		return !super.interpret(context);
	}
}
