/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import java.util.ArrayList;
import java.util.List;

/**
 * 呼び出された順にメッセージのみを格納する{@link MessageCollectable}。
 * 本クラスはリクエストごとに生成することを想定している。
 * @author nakamura
 *
 */
public class SimpleMessageCollector implements MessageCollectable {
	private final List<String> list;
	
	/**
	 * コンストラクタ。
	 */
	public SimpleMessageCollector(){
		this.list = new ArrayList<String>();
	}

	public void add(final String message, final ValidatorContext context) {
		list.add(message);
	}
	
	/**
	 * メッセージ一覧を返す。
	 * @return メッセージ一覧。
	 */
	public List<String> getList(){
		return list;
	}
	
	@Override public String toString(){
		return list.toString();
	}
}
