/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.config;

import java.util.HashMap;

import woolpack.utils.MapBuilder;
import junit.framework.TestCase;

public class ConfigConstantsTest extends TestCase {
	
	public void testToUnmodifiableMap(){
		final ConfigContext context = new ConfigContext();
		context.setMap(MapBuilder.get(new HashMap<String,Object>()).put("0", new Integer(0)).get());
		ConfigConstants.TO_UNMODIFIABLE_MAP.interpret(context);
		
		try{
			context.getMap().clear();
			fail();
		}catch(final UnsupportedOperationException expected){
		}
	}
	
	public void testMakeMap(){
		final ConfigContext context = new ConfigContext();
		ConfigConstants.MAKE_MAP.interpret(context);
		assertNotNull(context.getMap());
		assertTrue(context.getMap().isEmpty());
	}
	
	public void testToUnoverwritableMap(){
		final ConfigContext context = new ConfigContext();
		context.setMap(MapBuilder.get(new HashMap<String,Object>()).put("0", new Integer(0)).get());
		ConfigConstants.TO_UNOVERWRITABLE_MAP.interpret(context);
		
		context.getMap().put("1", new Integer(1));
		try{
			context.getMap().put("0", new Integer(0));
			fail();
		}catch(final IllegalStateException expected){
			assertEquals("already registered: 0", expected.getMessage());
		}
	}
}
