/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.config;

import java.util.HashMap;
import java.util.Map;

import woolpack.test.TestUtils;
import woolpack.utils.MapBuilder;

import junit.framework.TestCase;

public class RemoveNotResolvedTest extends TestCase {
	
	public void testNormal0(){
		final Map<String,Object> map = new HashMap<String,Object>();
		map.put("baseKey0", "baseValue0");
		map.put("baseKey1", "baseValue1");
		map.put("complexKey0", "x{baseKey0}y{baseKey1}z");
		map.put("abstractKey0", "a{0}b{1}c");
		map.put("complexKey1", "#{abstractKey0}{baseKey0}{baseKey1}");
		
		final ConfigExpression expression = new RemoveNotResolved();
		final ConfigContext context = new ConfigContext();
		context.setMap(map);
		expression.interpret(context);
		
		assertTrue(TestUtils.equals(
				MapBuilder.get(new HashMap<String,Object>())
				.put("baseKey0", "baseValue0")
				.put("baseKey1", "baseValue1")
				.get()
				, context.getMap()));
	}
}
