/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import java.util.Map;

import junit.framework.TestCase;
import woolpack.el.ELConstants;
import woolpack.el.ToELTargetExceptionEL;

public class DoELTest extends TestCase {

	public void testConstructor(){
		try{
			new DoEL("a", null);
			fail();
		}catch(final NullPointerException expected){
		}
		new DoEL("a", ELConstants.NULL);
	}
	
	public void testNormal(){
		final DomExpression expression = new DoEL("prefix_", new ToELTargetExceptionEL(){
			@Override public Object execute(Object root, Object value) throws Exception {
				final Map map = (Map)root;
				final DomContext context = (DomContext)map.get("context");
				context.getLocal().put("key0", map.get("resource") + context.getId());
				return null;
			}
		});
		final DomContext context = new DomContext();
		
		context.setId("id0");
		expression.interpret(context);
		assertEquals("prefix_id0", context.getLocal().get("key0"));
		
		context.setId("id1");
		expression.interpret(context);
		assertEquals("prefix_id1", context.getLocal().get("key0"));
		
		context.setId(null);
		expression.interpret(context);
		assertEquals("prefix_null", context.getLocal().get("key0"));
	}
}
