/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;
import woolpack.test.TestUtils;

public class NodeLoopTest extends TestCase {

	public void testNormal(){
		final List<String> list = new ArrayList<String>();
		final DomExpression expression = new Serial(
				TestUtils.getToNodeBody("<SPAN><SPAN>a</SPAN><SPAN>b</SPAN></SPAN><SPAN>c</SPAN>"),
			new NodeLoop(){
				public void interpret(final DomContext context) {
					list.add(context.getNode().getNodeName());
					super.interpret(context);
				}
			}
		);
		final DomContext context = new DomContext();
		expression.interpret(context);
		
		final List<String> expected = new ArrayList<String>();
		expected.add("#document");
		expected.add("HTML");
		expected.add("BODY");
		expected.add("SPAN");
		expected.add("SPAN");
		expected.add("#text");
		expected.add("SPAN");
		expected.add("#text");
		expected.add("SPAN");
		expected.add("#text");
		assertEquals(expected, list);
	}
}
