/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;

import junit.framework.TestCase;

public class CachePropertyELFactoryTest extends TestCase {
	int getCount = 0;
	int setCount = 0;

	public void testConstructor(){
		try{
			new CachePropertyELFactory(null);
			fail();
		}catch(final NullPointerException expected){
		}
	}
	
	public void testCount(){
		final PropertyELFactory factory = new CachePropertyELFactory(
				new PropertyELFactory(){
					public GettingEL newGetter(final Class clazz, final String propertyName) {
						getCount++;
						return new FixEL("getter:" + propertyName);
					}
					public EL newSetter(final Class clazz, final String propertyName) {
						setCount++;
						return new FixEL("setter:" + propertyName);
					}
				}
		);
		assertEquals(0, getCount);
		assertEquals("getter:hoge", ((FixEL)factory.newGetter(Integer.class, "hoge")).getValue());
		assertEquals(1, getCount);
		assertEquals("getter:hoge", ((FixEL)factory.newGetter(Integer.class, "hoge")).getValue());
		assertEquals(1, getCount);
		assertEquals("getter:piyo", ((FixEL)factory.newGetter(Integer.class, "piyo")).getValue());
		assertEquals(2, getCount);
		
		assertEquals(0, setCount);
		assertEquals("setter:hoge", ((FixEL)factory.newSetter(Integer.class, "hoge")).getValue());
		assertEquals(1, setCount);
		assertEquals("setter:hoge", ((FixEL)factory.newSetter(Integer.class, "hoge")).getValue());
		assertEquals(1, setCount);
		assertEquals("setter:piyo", ((FixEL)factory.newSetter(Integer.class, "piyo")).getValue());
		assertEquals(2, setCount);

		assertEquals(2, getCount);
	}
}
