/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el.convert;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;

import woolpack.text.BooleanFormat;
import woolpack.utils.SwitchBuilder;
import woolpack.validator.BranchByNameIfExistsValidator;
import woolpack.validator.DefaultValueValidator;
import woolpack.validator.ValidatorExpression;
import junit.framework.TestCase;

public class ConvertConstantsTest extends TestCase {

	public void testCollectionConverter(){
		final Convertable c = ConvertConstants.getCollectionConverter(
				new BranchByNameIfExistsValidator(new SwitchBuilder<String,ValidatorExpression>()
						.put("key0", new DefaultValueValidator("0"))
						.put("key1", new DefaultValueValidator("1"))
						.get()),
				new DecimalFormat(),
				new SimpleDateFormat(),
				new BooleanFormat());
		
		assertEquals("0", c.convert(new Object(), String.class, "key0"));
		assertEquals("1", c.convert(new Object(), String.class, "key1"));
		assertEquals(new Integer(0), c.convert(new Object(), Integer.class, "key0"));
		assertEquals(new Integer(1), c.convert(new Object(), Integer.class, "key1"));
	}
}
