/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el.convert;

import java.math.BigDecimal;
import java.math.BigInteger;

import junit.framework.TestCase;

public class NumberConverterTest extends TestCase {

	public void testNormal(){
		assertEquals(new Byte((byte)1), NumberConverter.convert(new Integer(1), Byte.class));
		assertEquals(new Short((short)1), NumberConverter.convert(new Integer(1), Short.class));
		assertEquals(new Integer(1), NumberConverter.convert(new Long(1), Integer.class));
		assertEquals(new Long(1), NumberConverter.convert(new Integer(1), Long.class));
		assertEquals(new Float(1), NumberConverter.convert(new Integer(1), Float.class));
		assertEquals(new Double(1), NumberConverter.convert(new Integer(1), Double.class));
		assertEquals(BigInteger.valueOf(1), NumberConverter.convert(new Integer(1), BigInteger.class));
		assertEquals(new BigDecimal(1), NumberConverter.convert(new Integer(1), BigDecimal.class));
	}
}
