/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el.convert;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;

import junit.framework.TestCase;
import woolpack.text.BooleanFormat;

public class ToTypeToWapperConverterTest extends TestCase {

	public void testConstructor(){
		try{
			new ToTypeToWapperConverter(null);
			fail();
		}catch(final NullPointerException expected){
		}
	}

	public void testNormal() throws ParseException{
		final Convertable c = new ToTypeToWapperConverter(new SimpleConverter(
				new DecimalFormat(), new SimpleDateFormat(), new BooleanFormat()
		));

		assertEquals(Boolean.TRUE, c.convert("true", boolean.class, null));
		assertEquals(Boolean.FALSE, c.convert("false", boolean.class, null));
		assertEquals(new Character('a'), c.convert("abc", char.class, null));
		assertEquals(new Byte((byte)1), c.convert("1", byte.class, null));
		assertEquals(new Short((short)1), c.convert("1", short.class, null));
		assertEquals(new Integer(1), c.convert("1", int.class, null));
		assertEquals(new Long(1), c.convert("1", long.class, null));
		assertEquals(new Float(1), c.convert("1", float.class, null));
		assertEquals(new Double(1), c.convert("1", double.class, null));
	}
}
