/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.html;

import java.util.LinkedHashMap;

import junit.framework.TestCase;

import org.w3c.dom.Element;

import woolpack.adapter.JXP;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.dom.Serial;
import woolpack.dom.XPath;
import woolpack.el.PathEL;
import woolpack.el.ToELTargetExceptionEL;
import woolpack.test.TestUtils;
import woolpack.utils.MapBuilder;

public class MakeRadioTest extends TestCase {

	public void testConstructor(){
		try{
			new MakeRadio(null);
			fail();
		}catch(final NullPointerException expected){
		}
	}
	
	public void testNormal(){
		final DomExpression expression = new Serial(
				TestUtils.getToNodeForm(
						"<SPAN>" +
						"<INPUT type=\"radio\" name=\"name1\" value=\"value\" />label" +
						"</SPAN>"),
				new XPath(new JXP("name", "name1"), new MakeRadio(new PathEL("local.map0"))));
		final DomContext context = new DomContext();
		context.getLocal().put("map0", 
				MapBuilder.get(new LinkedHashMap<String,Object>())
				.put("v0", "l0")
				.put("v1", "l1")
				.get());
		
		expression.interpret(context);

		assertTrue(TestUtils.equalsForm(context, 
				"<SPAN>" +
				"<INPUT type=\"radio\" name=\"name1\" value=\"v0\" />l0" +
				"<INPUT type=\"radio\" name=\"name1\" value=\"v1\" />l1" +
				"</SPAN>"));
	}
	
	public void testNotFound(){
		final DomExpression expression = new Serial(
				TestUtils.getToNodeForm(
						"<SPAN>" +
						"<INPUT type=\"radio\" name=\"name1\" value=\"value\" />label" +
						"</SPAN>"),
				new XPath(new JXP("name", "name1"), new MakeRadio(new PathEL("local.map0"))));
		final DomContext context = new DomContext();
		
		expression.interpret(context);

		assertTrue(TestUtils.equalsForm(context, 
				"<SPAN>" +
				"<INPUT type=\"radio\" name=\"name1\" value=\"value\" />label" +
				"</SPAN>"));
	}
	
	public void testTipsAuto(){
		final DomExpression expression = new Serial(
				TestUtils.getToNodeForm(
						"<SPAN>" +
						"<INPUT type=\"radio\" name=\"name1\" value=\"value\" />label" +
						"<INPUT type=\"radio\" name=\"name1\" value=\"value_a\" />label_a" +
						"<INPUT type=\"radio\" name=\"name1\" value=\"value_b\" />label_b" +
						"</SPAN>"),
				new XPath(
						new JXP("//INPUT[@type=\"radio\" or @type=\"checkbox\"]"), 
						new MakeRadio(new ToELTargetExceptionEL(){
							@Override public Object execute(Object root, Object value) throws Exception {
								// new OGE("local[node.getAttribute(\"name\")]")
								final DomContext context = (DomContext)root;
								return context.getLocal().get(((Element)context.getNode()).getAttribute("name"));
							}
						}), 
						HtmlConstants.REMOVE_THIS_AND_TEXTS));
		final DomContext context = new DomContext();
		context.getLocal().put("name1", 
				MapBuilder.get(new LinkedHashMap<String,Object>())
				.put("v0", "l0")
				.put("v1", "l1")
				.get());
		
		expression.interpret(context);

		assertTrue(TestUtils.equalsForm(context, 
				"<SPAN>" +
				"<INPUT type=\"radio\" name=\"name1\" value=\"v0\" />l0" +
				"<INPUT type=\"radio\" name=\"name1\" value=\"v1\" />l1" +
				"</SPAN>"));
	}
}
