/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.locale;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import junit.framework.TestCase;
import woolpack.config.ConfigConstants;
import woolpack.config.ConfigContext;
import woolpack.config.ConfigCount;
import woolpack.config.ConfigExpression;
import woolpack.config.PutResourceBundle;

public class LocaleCacheMapTest extends TestCase {

	public void testConstructor(){
		try{
			new LocaleCacheMap(new HashMap<Object,Map<String,Object>>(), null, new ThreadLocal<Locale>());
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new LocaleCacheMap(new HashMap<Object,Map<String,Object>>(), ConfigConstants.NULL, null);
			fail();
		}catch(final NullPointerException expected){
		}
		new LocaleCacheMap(null, ConfigConstants.NULL, new ThreadLocal<Locale>());
	}
	
	public void testCacheOn(){
		final ThreadLocal<Locale> threadLocal = new ThreadLocal<Locale>();
		final ConfigCount counter0 = new ConfigCount(new PutResourceBundle("woolpack.config.ResourceBundle2MapTest"));
		final ConfigExpression expression = new LocaleCacheMap(new HashMap<Object,Map<String,Object>>(), counter0, threadLocal);
		
		final ConfigContext context0 = new ConfigContext();
		threadLocal.set(Locale.JAPANESE);
		context0.setMap(new HashMap<String, Object>());
		expression.interpret(context0);
		assertEquals(1, counter0.getCount());
		assertTrue(context0 == counter0.getContextList().getLast());
		
		final ConfigContext context1 = new ConfigContext();
		threadLocal.set(Locale.JAPANESE);
		context1.setMap(new HashMap<String, Object>());
		expression.interpret(context1);
		assertEquals(context0.getMap(), context1.getMap());
		assertEquals(1, counter0.getCount());
		assertTrue(context0 == counter0.getContextList().getLast());
		
		final ConfigContext context2 = new ConfigContext();
		threadLocal.set(Locale.ENGLISH);
		context2.setMap(new HashMap<String, Object>());
		expression.interpret(context2);
		assertTrue(context0.getMap().equals(context2.getMap()));
		assertEquals(2, counter0.getCount());
		assertTrue(context2 == counter0.getContextList().getLast());

		final ConfigContext context3 = new ConfigContext();
		threadLocal.set(null);
		context3.setMap(new HashMap<String, Object>());
		expression.interpret(context3);
		assertEquals(3, counter0.getCount());
		assertTrue(context3 == counter0.getContextList().getLast());
		
		final ConfigContext context4 = new ConfigContext();
		threadLocal.set(null);
		context4.setMap(new HashMap<String, Object>());
		expression.interpret(context4);
		assertEquals(context3.getMap(), context4.getMap());
		assertEquals(3, counter0.getCount());
		assertTrue(context3 == counter0.getContextList().getLast());
	}
	
	public void testCacheOff(){
		final ThreadLocal<Locale> threadLocal = new ThreadLocal<Locale>();
		final ConfigCount counter0 = new ConfigCount(new PutResourceBundle("woolpack.config.ResourceBundle2MapTest"));
		final ConfigExpression expression = new LocaleCacheMap(null, counter0, threadLocal);
		
		final ConfigContext context0 = new ConfigContext();
		threadLocal.set(Locale.JAPANESE);
		context0.setMap(new HashMap<String, Object>());
		expression.interpret(context0);
		assertEquals(1, counter0.getCount());
		assertTrue(context0 == counter0.getContextList().getLast());
		
		final ConfigContext context1 = new ConfigContext();
		threadLocal.set(Locale.JAPANESE);
		context1.setMap(new HashMap<String, Object>());
		expression.interpret(context1);
		assertEquals(context0.getMap(), context1.getMap());
		assertEquals(2, counter0.getCount());
		assertTrue(context1 == counter0.getContextList().getLast());

		final ConfigContext context2 = new ConfigContext();
		threadLocal.set(Locale.ENGLISH);
		context2.setMap(new HashMap<String, Object>());
		expression.interpret(context2);
		assertTrue(context0.getMap().equals(context2.getMap()));
		assertEquals(3, counter0.getCount());
		assertTrue(context2 == counter0.getContextList().getLast());

		final ConfigContext context3 = new ConfigContext();
		threadLocal.set(null);
		context3.setMap(new HashMap<String, Object>());
		expression.interpret(context3);
		assertEquals(4, counter0.getCount());
		assertTrue(context3 == counter0.getContextList().getLast());
		
		final ConfigContext context4 = new ConfigContext();
		threadLocal.set(null);
		context4.setMap(new HashMap<String, Object>());
		expression.interpret(context4);
		assertEquals(context3.getMap(), context4.getMap());
		assertEquals(5, counter0.getCount());
		assertTrue(context4 == counter0.getContextList().getLast());
	}
}
