/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.text;

import java.text.Format;
import java.text.ParseException;

import junit.framework.TestCase;

public class ToCharacterFormatTest extends TestCase {
	
	private void scenario(final Format format) throws ParseException{
		assertEquals("a", format.format(new Character('a')));
		assertEquals(new Character('a'), format.parseObject("abc"));
	}

	public void testNormal() throws ParseException{
		final Format format0 = new ToCharacterFormat();
		scenario(format0);
		final Format format1 = (Format)format0.clone();
		assertTrue(format0 != format1);
		scenario(format1);
	}
}
