/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

import junit.framework.TestCase;
import woolpack.test.TestUtils;
import woolpack.utils.MapBuilder;

public class RetainNamesValidatorTest extends TestCase {

	public void testConstructor(){
		try{
			new RetainNamesValidator(null);
			fail();
		}catch(final NullPointerException expected){
		}
	}

	public void testNormal(){
		final ValidatorExpression expression = new RetainNamesValidator(Arrays.asList("a0", "a2", "a4"));
		final ValidatorContext context = new ValidatorContext();

		context.setInputMap(MapBuilder.get(new HashMap<String,List<Object>>())
				.put("a0", Arrays.asList((Object)"v"))
				.put("a1", Arrays.asList((Object)"v"))
				.get());
		assertTrue(expression.interpret(context));
		assertTrue(TestUtils.equals(Arrays.asList("a0"), context.getInputMap().keySet()));
	}
}
