/*
 * Decompiled with CFR 0.152.
 */
package woolpack.config;

import java.util.Collections;
import java.util.LinkedHashMap;
import woolpack.config.ConfigContext;
import woolpack.config.ConfigExpression;
import woolpack.utils.CheckUtils;

public class ToLinkedHashMap
implements ConfigExpression {
    private final String newMapListPosition;
    private final String valueSourcePosition;
    private final String labelSourcePosition;
    private final String separator;

    public ToLinkedHashMap(String newMapListPosition, String valueSourcePosition, String labelSourcePosition, String separator) {
        CheckUtils.checkNotEmpty(newMapListPosition);
        CheckUtils.checkNotEmpty(valueSourcePosition);
        CheckUtils.checkNotEmpty(labelSourcePosition);
        CheckUtils.checkNotEmpty(separator);
        this.newMapListPosition = newMapListPosition;
        this.valueSourcePosition = valueSourcePosition;
        this.labelSourcePosition = labelSourcePosition;
        this.separator = separator;
    }

    public void interpret(ConfigContext context) {
        String[] labelArray;
        String[] valueArray = ((String)context.getMap().get(this.valueSourcePosition)).split(this.separator);
        if (valueArray.length != (labelArray = ((String)context.getMap().get(this.labelSourcePosition)).split(this.separator)).length) {
            throw new ArrayIndexOutOfBoundsException("length unmatch : " + this.valueSourcePosition + " and " + this.labelSourcePosition);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        int i = 0;
        while (i < valueArray.length) {
            map.put(valueArray[i], labelArray[i]);
            ++i;
        }
        context.getMap().put(this.newMapListPosition, Collections.unmodifiableMap(map));
    }
}

