/*
 * Decompiled with CFR 0.152.
 */
package woolpack.dom;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;
import woolpack.utils.AppendableWriter;
import woolpack.utils.MapIterableMap;
import woolpack.utils.UtilsConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomContext {
    private String id;
    private Map<String, Object> config;
    private Object container;
    private Map input;
    private Map<String, Object> request;
    private ConcurrentMap<String, Object> session;
    private ConcurrentMap<String, Object> application;
    private Map<String, Object> beforeLocal;
    private Map<String, Object> local;
    private Node node;

    public DomContext() {
    }

    public DomContext(DomContext base) {
        this.id = base.id;
        this.config = base.config;
        this.container = base.container;
        this.input = base.input;
        this.request = base.request;
        this.session = base.session;
        this.application = base.application;
        this.beforeLocal = base.local != null ? base.local : base.beforeLocal;
        this.node = base.node;
    }

    public DomContext copy() {
        return new DomContext(this);
    }

    public Map<String, Object> getLocal() {
        if (this.local == null) {
            this.local = this.beforeLocal == null ? new HashMap<String, Object>() : new MapIterableMap<String, Object>((Iterable)Arrays.asList(new HashMap(), this.beforeLocal));
        }
        return this.local;
    }

    public void appendTo(Appendable sb) throws IOException {
        sb.append("DomContext dump information:");
        DomContext.appendTo(sb, "id", this.id);
        DomContext.appendTo(sb, "config", this.config);
        DomContext.appendTo(sb, "container", this.container);
        DomContext.appendTo(sb, "input", this.input);
        DomContext.appendTo(sb, "request", this.request);
        DomContext.appendTo(sb, "session", this.session);
        DomContext.appendTo(sb, "application", this.application);
        DomContext.appendTo(sb, "local", this.local);
        sb.append("\n,node:");
        if (this.node != null) {
            UtilsConstants.TRANSFORMER_FACTORY.newInstance().transform(new DOMSource(this.node), new StreamResult(new AppendableWriter(sb)));
        }
    }

    private static void appendTo(Appendable sb, String label, Object o) throws IOException {
        sb.append('\n');
        sb.append(',');
        sb.append(label);
        sb.append(':');
        if (o != null) {
            sb.append(o.toString());
        }
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, Object> config) {
        this.config = config;
    }

    public Object getContainer() {
        return this.container;
    }

    public void setContainer(Object container) {
        this.container = container;
    }

    public Map<String, Object> getRequest() {
        return this.request;
    }

    public void setRequest(Map<String, Object> request) {
        this.request = request;
    }

    public ConcurrentMap<String, Object> getSession() {
        return this.session;
    }

    public void setSession(ConcurrentMap<String, Object> session) {
        this.session = session;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Map getInput() {
        return this.input;
    }

    public void setInput(Map input) {
        this.input = input;
    }

    public ConcurrentMap<String, Object> getApplication() {
        return this.application;
    }

    public void setApplication(ConcurrentMap<String, Object> application) {
        this.application = application;
    }
}

