/*
 * Decompiled with CFR 0.152.
 */
package woolpack.dom;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.utils.CheckUtils;
import woolpack.utils.ReaderFactory;
import woolpack.utils.UtilsConstants;
import woolpack.utils.XmlTransformerFactory;

public class XmlToNode
implements DomExpression {
    private final ReaderFactory readerFactory;
    private final XmlTransformerFactory transformerFactory;

    public XmlToNode(ReaderFactory readerFactory) {
        this(readerFactory, UtilsConstants.TRANSFORMER_FACTORY);
    }

    public XmlToNode(ReaderFactory readerFactory, XmlTransformerFactory transformerFactory) {
        CheckUtils.checkNotNull(readerFactory);
        CheckUtils.checkNotNull(transformerFactory);
        this.readerFactory = readerFactory;
        this.transformerFactory = transformerFactory;
    }

    public void interpret(DomContext context) {
        DOMResult result = new DOMResult();
        try {
            Reader r = this.readerFactory.newInstance(context.getId());
            if (r == null) {
                throw new IllegalStateException(new FileNotFoundException("not found : " + context.getId()));
            }
            try {
                StreamSource source = new StreamSource(r);
                this.transformerFactory.newInstance().transform(source, result);
            }
            finally {
                r.close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        context.setNode(result.getNode());
    }
}

