/*
 * Decompiled with CFR 0.152.
 */
package woolpack.el;

import java.util.Map;
import woolpack.el.AbstractEL;
import woolpack.el.convert.ConvertConstants;
import woolpack.el.convert.Convertable;
import woolpack.utils.CheckUtils;

public class MapEL
extends AbstractEL {
    private final String key;
    private final Convertable convertable;

    public MapEL(String key, Convertable convertable) {
        CheckUtils.checkNotEmpty(key);
        CheckUtils.checkNotNull(convertable);
        this.key = key;
        this.convertable = convertable;
    }

    public MapEL(String key) {
        this(key, ConvertConstants.COLLECTION_CONVERTER);
    }

    public void setValue(Object root, Object value) {
        Object newValue = this.convertable.convert(value, Object.class, this.key);
        ((Map)root).put(this.key, newValue);
    }

    public Object getValue(Object root, Class toType) {
        Object result = ((Map)root).get(this.key);
        return this.convertable.convert(result, toType, this.key);
    }

    public Convertable getConvertable() {
        return this.convertable;
    }

    public String getKey() {
        return this.key;
    }
}

