/*
 * Decompiled with CFR 0.152.
 */
package woolpack.html;

import java.util.Map;
import org.w3c.dom.Node;
import woolpack.dom.DomConstants;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.el.GettingEL;
import woolpack.utils.CheckUtils;
import woolpack.utils.UtilsConstants;

public class UpdateToSelectedValue
implements DomExpression {
    private final GettingEL valueEL;
    private final GettingEL mapEL;

    public UpdateToSelectedValue(GettingEL valueEL, GettingEL mapEL) {
        CheckUtils.checkNotNull(valueEL);
        this.valueEL = valueEL;
        this.mapEL = mapEL;
    }

    public void interpret(DomContext context) {
        Object value1 = this.valueEL.getValue(context);
        Iterable iterable = UtilsConstants.toIterable(value1);
        for (Object value : iterable) {
            if (value == null) continue;
            String valueString = value.toString();
            Node newNode = context.getNode().cloneNode(true);
            DomConstants.removeChildren(newNode);
            try {
                Map map = (Map)this.mapEL.getValue(context);
                if (map.containsKey(valueString)) {
                    DomConstants.appendText(newNode, map.get(valueString).toString());
                }
            }
            catch (RuntimeException e) {
                DomConstants.appendText(newNode, valueString);
            }
            context.getNode().getParentNode().insertBefore(newNode, context.getNode());
        }
        DomConstants.removeThis(context.getNode());
    }
}

