/*
 * Decompiled with CFR 0.152.
 */
package woolpack.text;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.regex.Pattern;
import woolpack.utils.CheckUtils;

public class RegExpFormat
extends Format {
    private static final long serialVersionUID = 1L;
    private final Pattern pattern;
    private final String replacement;

    public RegExpFormat(Pattern pattern, String replacement) {
        CheckUtils.checkNotNull(pattern);
        CheckUtils.checkNotEmpty(replacement);
        this.pattern = pattern;
        this.replacement = replacement;
    }

    public RegExpFormat(String pattern, String replacement) {
        this(Pattern.compile(pattern), replacement);
    }

    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        int start = toAppendTo.length();
        toAppendTo.append(this.convert((String)obj));
        pos.setBeginIndex(start);
        pos.setEndIndex(toAppendTo.length());
        return toAppendTo;
    }

    public Object parseObject(String source, ParsePosition pos) {
        int i = pos.getIndex();
        pos.setIndex(source.length());
        return this.convert(source.substring(i));
    }

    private String convert(String before) {
        return this.pattern.matcher(before).replaceAll(this.replacement);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getReplacement() {
        return this.replacement;
    }
}

